
program points;

type point = record
   x, y       : int64;
   broj, boja : longint;
end;            

function ccw(A, B, C : point ) : integer;
var t : int64;
begin
   t := (B.x-A.x)*(C.y-A.y) - (C.x-A.x)*(B.y-A.y);
   if t < 0 then ccw := -1;
   if t > 0 then ccw := 1;
   if t = 0 then ccw := 0;
end;

function inside(A, B, C, T : point ) : integer;
var x : integer;
begin
   x := ccw( A, B, C );
   if ccw( A, B, T ) <> x then inside := 0
   else if ccw( B, C, T ) <> x then inside := 0
   else if ccw( C, A, T ) <> x then inside := 0
   else inside := 1;
end;

function boja(x : integer) : char;
begin
   if x = 0 then boja := 'g' else boja := 'r';
end;

procedure solve(A, B, C  : point; var tocke : Array of point; n : longint );
var
   unutar : Array of point;
   i, m    : longint;
begin
   SetLength( unutar, n+1 );
   m := 0;
   for i := 1 to n do begin
      if inside( A, B, C, tocke[i] ) = 1 then begin
         m := m + 1;
         unutar[m] := tocke[i];
      end;
   end;
  
   for i := 1 to m do begin
      if unutar[i].boja = C.boja then begin
         writeln( C.broj, ' ', unutar[i].broj, ' ', boja(C.boja) );
         solve( A, B, unutar[i], unutar, m );
         solve( C, unutar[i], A, unutar, m );
         solve( C, unutar[i], B, unutar, m );
         exit;
      end;
   end;

   for i := 1 to m do begin
      writeln( A.broj, ' ', unutar[i].broj, ' ', boja(A.boja) );
   end; 
end;
                
var
   tocke   : Array of point;
   G, R, i : longint;

begin
   SetLength( tocke, 100001 );
   
   readln( G );
   for i := 1 to G do begin
      readln( tocke[i].x, tocke[i].y );
      tocke[i].boja := 0;
      tocke[i].broj := i;
   end;
  
   readln( R );
   for i := 1 to R do begin
      readln( tocke[G+i].x, tocke[G+i].y );
      tocke[G+i].boja := 1;
      tocke[G+i].broj := i;
   end;

   writeln( '1 2 g' );
   writeln( '1 2 r' );

   solve( tocke[1], tocke[2], tocke[G+1], tocke, G+R );
   solve( tocke[G+1], tocke[G+2], tocke[2], tocke, G+R );
end.
