
#include <cstdio>
#include <vector>

using namespace std;

typedef long long llint;

struct point {
   llint x, y;
   int broj, boja;
};

int ccw( const point &A, const point &B, const point &C ) {
   llint t = (B.x-A.x)*(C.y-A.y) - (C.x-A.x)*(B.y-A.y);
   if( t < 0 ) return -1;
   if( t > 0 ) return 1;
   return 0;
}

inline int inside( const point &A, const point &B, const point &C, const point &T ) {
   int x = ccw( A, B, C );
   if( ccw( A, B, T ) != x ) return 0;
   if( ccw( B, C, T ) != x ) return 0;
   if( ccw( C, A, T ) != x ) return 0;
   return 1;
}

inline char boja( int x ) { return x == 0 ? 'g' : 'r'; }

void solve( point A, point B, point C, vector<point> &tocke ) {
   vector<point> unutar;

   for( vector<point>::iterator it = tocke.begin(); it != tocke.end(); ++it ) 
      if( inside( A, B, C, *it ) )
         unutar.push_back( *it );

   for( vector<point>::iterator it = unutar.begin(); it != unutar.end(); ++it ) 
      if( it->boja == C.boja ) {
         printf( "%d %d %c\n", C.broj, it->broj, boja(C.boja) );
         solve( A, B, *it, unutar );
         solve( C, *it, A, unutar );
         solve( C, *it, B, unutar );
         return;
      }

   for( vector<point>::iterator it = unutar.begin(); it != unutar.end(); ++it ) 
      printf( "%d %d %c\n", A.broj, it->broj, boja(A.boja) );
}

int main( void ) {
   vector<point> tocke;

   int G, R;
   scanf( "%d", &G );
   for( int i = 0; i < G; ++i ) {
      point P; 
      P.boja = 0; P.broj = i+1;
      scanf( "%lld%lld", &P.x, &P.y );
      tocke.push_back( P );
   }

   scanf( "%d", &R );
   for( int i = 0; i < R; ++i ) {
      point P; 
      P.boja = 1; P.broj = i+1;
      scanf( "%lld%lld", &P.x, &P.y );
      tocke.push_back( P );
   }

   printf( "%d %d %c\n", 1, 2, 'g' );
   printf( "%d %d %c\n", 1, 2, 'r' );

   solve( tocke[0], tocke[1], tocke[G], tocke );
   solve( tocke[G], tocke[G+1], tocke[1], tocke );
   
   return 0;
}
