
program mexico;

type state = record
   a, b, x : integer;
end;      

var
   n, m  : longint;
   a, b, i, j : longint;
   g : array[1..1000,1..1000] of longint;
   queue : array[1..2000000] of state;
   qhead, qtail : longint;
   bio  : array[1..1000,1..1000,0..1] of integer;
   how  : array[1..1000,1..1000,0..1] of state;
   S, T  : state;

function prev(x : integer) : integer;
begin
   if x = 1 then prev := n else prev := x-1;
end;
function next(x : integer) : integer;
begin
   if x = n then next := 1 else next := x+1;
end;

procedure update(T, S : state);
begin
   if bio[T.a,T.b,T.x] = 0 then
   begin
      how[T.a,T.b,T.x] := S;
      bio[T.a,T.b,T.x] := 1;
      queue[qtail] := T;
      qtail := qtail + 1;
   end;
end;

begin
   readln( n, m );
   qhead := 1; qtail := 1;
   for i := 1 to n do begin
      for j := 1 to n do begin
         bio[i,j,0] := 0;
         bio[i,j,1] := 0;
         g[i,j] := 0;
      end;
   end;

   for i := 1 to m do begin
      readln( a, b );
      g[a][b] := 1;
      g[b][a] := 1;
   end;

   S.a := 0; S.b := 0; S.x := 0;
   for i := 1 to n do begin
      T.a := i; T.b := i; T.x := 0; update( T, S );
      T.a := i; T.b := i; T.x := 1; update( T, S );
   end;

   while qhead <> qtail do begin
      S := queue[qhead];
      qhead := qhead + 1;

      if prev(S.a) = S.b then begin
         while S.a <> S.b do begin
            if S.x = 0 then writeln( S.a );
            if S.x = 1 then writeln( S.b );
            S := how[S.a,S.b,S.x];
         end;
         writeln( S.a );
         exit;
      end;

      if S.x = 0 then begin
         if g[S.a,prev(S.a)] = 1 then begin
            T.a := prev(S.a); T.b := S.b; T.x := 0;
            update( T, S );
         end;
         if g[S.a,next(S.b)] = 1 then begin
            T.a := S.a; T.b := next(S.b); T.x := 1;
            update( T, S );
         end;
      end else begin
         if g[S.b,prev(S.a)] = 1 then begin
            T.a := prev(S.a); T.b := S.b; T.x := 0;
            update( T, S );
         end;
         if g[S.b,next(S.b)] = 1 then begin
            T.a := S.a; T.b := next(S.b); T.x := 1;
            update( T, S );
         end;
      end;
   end;
   
   writeln( -1 );
end.
