
#include <cstdio>
#include <queue>

using namespace std;

struct state {
   int a, b, x;
   state() {}
   state( int A, int B, int X ) { a=A; b=B; x=X; }
};

int n, m;
int g[1000][1000];

queue<state> Q;

char bio[1000][1000][2];
state how[1000][1000][2];

inline int prev( int x ) { return (x == 0) ? n-1 : x-1; }
inline int next( int x ) { return (x+1 == n) ? 0 : x+1; }

inline void update( const state &T, const state &S ) {
   if( bio[T.a][T.b][T.x] ) return;
   how[T.a][T.b][T.x] = S;
   bio[T.a][T.b][T.x] = 1;
   Q.push( T );
}

int main( void ) {
   scanf( "%d%d", &n, &m );
   for( int i = 0; i < m; ++i ) {
      int a, b;
      scanf( "%d%d", &a, &b ); --a; --b;
      g[a][b] = g[b][a] = 1;
   }

   for( int i = 0; i < n; ++i ) {
      update( state(i,i,0), state() );
      update( state(i,i,1), state() );
   }

   for( ; !Q.empty(); Q.pop() ) {
      state S = Q.front();
      if( prev( S.a ) == S.b ) {
         
         for( ; S.a != S.b; S = how[S.a][S.b][S.x] ) {
            if( S.x == 0 ) printf( "%d\n", S.a+1 );
            if( S.x == 1 ) printf( "%d\n", S.b+1 );
         }
         printf( "%d\n", S.a+1 );

         return 0;
      }

      if( S.x == 0 ) {
         if( g[S.a][prev(S.a)] ) update( state( prev(S.a), S.b, 0 ), S );
         if( g[S.a][next(S.b)] ) update( state( S.a, next(S.b), 1 ), S );
      } else {
         if( g[S.b][prev(S.a)] ) update( state( prev(S.a), S.b, 0 ), S );
         if( g[S.b][next(S.b)] ) update( state( S.a, next(S.b), 1 ), S );
      }
   }
   printf( "-1\n" );
   
   return 0;
}
